/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.io.File;
import skeletonapplet.Utilities;

public abstract class AbstractFileInfo {
    protected String baseFileName;
    protected int length;
    protected long checkSum;
    public static final int NUMBER_OF_CHUNK_DIGITS = 4;
    public static final String CHUNK_FIELD_SEPARATOR = "_";
    public static final String CHUNK_SPECS_BEGIN = "[";
    public static final String CHUNK_SPEC_SEPARATOR = ",";
    public static final String CHUNK_SPECS_END = "]";
    public static final String SPEC_FIELD_SEPARATOR = "|";
    public static final String SPEC_SEPARATOR = ";";

    public abstract void addSpec(StringBuilder var1);

    public abstract void parseSpec(String var1);

    public AbstractFileInfo() {
    }

    public AbstractFileInfo(String string, int n, long l) {
        this.baseFileName = string;
        this.length = n;
        this.checkSum = l;
    }

    public String getBaseFileName() {
        return this.baseFileName;
    }

    public String getDownloadFileName() {
        return this.baseFileName;
    }

    public int getLength() {
        return this.length;
    }

    public String getSpec() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addSpec(stringBuilder);
        return stringBuilder.toString();
    }

    public boolean hasChunks() {
        return false;
    }

    public String toString() {
        return this.getSpec();
    }

    public boolean validate(byte[] byArray) {
        if (byArray == null) {
            Utilities.println("\tIS NULL");
            return false;
        }
        if (byArray.length != this.length) {
            Utilities.println("\tdata.length = " + byArray.length);
            Utilities.println("\tlength = " + this.length);
            return false;
        }
        if (Utilities.calculateCheckSum(byArray) != this.checkSum) {
            Utilities.println("\tUtilities.calculateCheckSum(data) = " + Utilities.calculateCheckSum(byArray));
            Utilities.println("\tcheckSum = " + this.checkSum);
            return false;
        }
        return true;
    }

    public boolean validate(File file) {
        byte[] byArray = null;
        try {
            byArray = Utilities.readBytes(file);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        return this.validate(byArray);
    }
}

